using System;

using gov.va.med.vbecs.DAL.VistALink.Client;
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;

namespace gov.va.med.vbecs.DAL.VAL
{
	/// <summary>
	/// Defines VistALink UI binding interfaces used to decouple VistALink 
	/// data access code from the UI that controls it. 
	/// </summary>
	public interface IVistALinkUIBinder
	{
		/// <summary>
		/// Gets access and verify codes from actor (user or service) via set of output parameters.
		/// </summary>
		/// <param name="serverInfo">Remote server general information.</param>
		/// <param name="serverConnectionInfo">Remote server connection information.</param>
		/// <param name="accessCode">Access code provided by actor.</param>
		/// <param name="verifyCode">Verify code provided by actor.</param>
		/// <param name="requestVerifyCodeChangeFlag">Indicator set by actor if verify code change is needed.</param>
		/// <returns>True if actor provides data and elects to continue logon process. False if actor cancels VistALink logon.</returns>
		bool GetVistAAccessAndVerifyCodes( RemoteServerSetupAndIntroInfo serverInfo, ServerConnectionInfo serverConnectionInfo, out VistASecurityCode accessCode, out VistASecurityCode verifyCode, out bool requestVerifyCodeChangeFlag );
		
		/// <summary>
		/// Gets actor division selection via output parameters.
		/// </summary>
		/// <param name="serverInfo">Remote server general information.</param>
		/// <param name="serverConnectionInfo">Remote server connection information.</param>
		/// <param name="divisionList">List of divisions to present to actor for selection.</param>
		/// <param name="userSelectedDivision">Division selected by actor.</param>
		/// <returns>True if actor provides data and elects to continue logon process. False if actor cancels VistALink logon.</returns>
		bool GetVistADivisionSelection( RemoteServerSetupAndIntroInfo serverInfo, ServerConnectionInfo serverConnectionInfo, DivisionInfoCollection divisionList, out DivisionInfo userSelectedDivision );
		
		/// <summary>
		/// Gets old, new and new check verify codes from actor for a verify code change.
		/// </summary>
		/// <param name="serverInfo">Remote server general information.</param>
		/// <param name="serverConnectionInfo">Remote server connection information.</param>
		/// <param name="oldVerifyCode">Old verify code.</param>
		/// <param name="newVerifyCode">New verify code.</param>
		/// <param name="newCheckVerifyCode">New check verify code.</param>
		/// <returns>True if actor provides data and elects to continue logon process. False if actor cancels VistALink logon.</returns>
		bool GetVistANewVerifyCode( RemoteServerSetupAndIntroInfo serverInfo, ServerConnectionInfo serverConnectionInfo, out VistASecurityCode oldVerifyCode, out VistASecurityCode newVerifyCode, out VistASecurityCode newCheckVerifyCode );
		
		/// <summary>
		/// Notifies actor about the problem occured.
		/// </summary>
		/// <param name="message">User-friendly message to provide to actor.</param>
		void NotifyAboutProblem( string message );
		
		/// <summary>
		/// Checks VistALink connection by sending ping and tries to reconnect (if needed) by invoking UC103 (BR_103.1, BR_103.02).
		/// </summary>
		/// <returns>True if VistALink is operational (was already available or restored), otherwise (VistALink is down) - false.</returns>
		bool CheckVistALinkReconnectIfNeeded();
	}
}
